/* -LICENSE-START-
 ** Copyright (c) 2015 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */

#include "VideoWriter.h"
#include <fcntl.h>

VideoWriter::VideoWriter(const QString& filename)
:
	m_filename(filename)
{
}

VideoWriter::~VideoWriter()
{	
}

bool VideoWriter::writeVideo(uint8_t* buffer, uint32_t length)
{
	fwrite(buffer, 1, length, m_file);
	return true;
}

bool VideoWriter::writeAudio(uint64_t)
{
	return true;
}

bool VideoWriter::addVideoStream()
{
	return true;
}

bool VideoWriter::addAudioStream()
{
	return true;
}

bool VideoWriter::open()
{
	m_file = fopen(m_filename.toStdString().c_str(), "wb");
	if (!m_file)
		return false;
	
	return true;
}

void VideoWriter::close(bool deleteFile)
{
	fclose(m_file);
	if (deleteFile)
		remove(m_filename.toStdString().c_str());
	m_file = 0;
}
